/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators;

import com.ibm.hwmca.fw.servlet.pmod.datamodel.PmCustomDataValidator;
import com.ibm.hwmca.fw.servlet.pmod.datamodel.ValidationException;
import com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.Validator;
import com.ibm.hwmca.fw.system.ClientUserContext;
import com.ibm.hwmca.fw.system.NullContextException;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ps.wcl.core.form.WTimeChooser;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Properties;

public class StrictTimeValidator
extends Validator
implements PmCustomDataValidator {
    private static final String TRACE_MASKT = "XPMNVDST";
    private static final String TRACE_MASKF = "XPMNVDSF";
    private Properties properties;

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void validate(Object value) throws ValidationException {
        if (value != null) {
            if (this.component instanceof WTimeChooser) {
                WTimeChooser wtc = (WTimeChooser)this.component;
                String rString = wtc.getText();
                Trace.trace(TRACE_MASKF, "StrictTimeValidator validating raw string: '" + rString + "'");
                DateFormat df = DateFormat.getTimeInstance(wtc.isSecondsFieldVisible() ? 2 : 3, this.triggerContext.getLocale());
                try {
                    ClientUserContext userContext = ClientUserContext.getUserContext();
                    df.setTimeZone(userContext.getTimeZone());
                }
                catch (NullContextException e) {
                    // empty catch block
                }
                df.setLenient(false);
                ParsePosition pp = new ParsePosition(0);
                Date time = df.parse(rString, pp);
                if (time == null || pp.getIndex() != rString.length()) {
                    Trace.trace(TRACE_MASKF, "StrictTimeValidator throwing validation exception (didn't parse correctly)");
                    throw new ValidationException(new MessageText("com.ibm.hwmca.fw.servlet.pmod.impl.nodes.validators.res.validator", "StrictTimeParseFailure"));
                }
            } else {
                Trace.trace(TRACE_MASKF, "StrictTimeValidator being asked to validate but given non WTimeChooser?");
            }
        } else {
            Trace.trace(TRACE_MASKF, "StrictTimeValidator.validate(" + value + ") accepted (null)");
        }
    }
}

